﻿using System;
using NCMS;
using System.Net;
using System.IO;
using System.Text;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.Events;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using ReflectionUtility;

namespace Diplomacy_Army
{
	[ModEntry]
	public class MoreGodPower
	{
		public static Kingdom selected_kingdom;
		public static City selected_city;
		//public static bool cantOwnCityLimited;
		public static Dictionary<string, bool> toggles = new Dictionary<string, bool>() { { "封锁边境", false },
																						  { "更多外交", false }, 
																						  { "显示条约", false },
																						  { "显示交战", false } ,
																						  { "显示外交消息", false } };
		public static Dictionary<Kingdom, Dictionary<Kingdom,int>> AllianceKingdoms = new Dictionary<Kingdom, Dictionary<Kingdom,int>>();
		public static Dictionary<Kingdom, Dictionary<Kingdom,int>> DefenceKingdoms = new Dictionary<Kingdom, Dictionary<Kingdom,int>>();
		public static Dictionary<Kingdom, Dictionary<Kingdom, int>> ArmyKingdoms = new Dictionary<Kingdom, Dictionary<Kingdom, int>>();
		public static Dictionary<Kingdom, List<Kingdom>> KingdomsTryArmy = new Dictionary<Kingdom, List<Kingdom>>();
		public static List<City> citiesCelebrate = new List<City>();
		public static List<Kingdom> KingdomsOwnedByPlayer = new List<Kingdom>();
		public static Dictionary<string, GameObject> newGameObjects = new Dictionary<string, GameObject>();

		public static void init()
		{
			#region godPower
			Transform pParent = null;
			foreach (GameObject gameObject in Resources.FindObjectsOfTypeAll<GameObject>())
			{
				if (gameObject.transform.name == "Tab_Main")
				{
					pParent = gameObject.transform;
					break;
				}
			}
			int num = 0;

			/*
			GodPower godPower1 = new GodPower();
			godPower1.id = "指定宣战";
			godPower1.name = "指定宣战";
			godPower1.unselectWhenWindow = true;
			godPower1.click_action = (PowerActionWithID)Delegate.Combine(godPower1.click_action, new PowerActionWithID(tryToWar));
			AssetManager.powers.add(godPower1);
			NewFunction.CreateNewButton(num++, pParent, "spite", godPower1, "强制国家之间开战", null, PowerButtonType.Active);
			*/
			CreateNewActiveGodpower(num++, pParent, "指定宣战", "spite", "强制国家之间开战");
			CreateNewActiveGodpower(num++, pParent, "指定和平", "friendship", "强制国家之间和平");
			CreateNewSpecialGodpower(num++, pParent, "全屏烟花", "friendship", "所有城市放一次烟花");
			num++;
			CreateNewActiveGodpower(num++, pParent, "国家操作", "Kingdoms", "国家相关的操作",new UnityAction(tryToOpenWindow));
			CreateNewActiveGodpower(num++, pParent, "村庄操作", "cityZones", "村庄相关的操作", new UnityAction(tryToOpenWindow2));
			CreateNewActiveGodpower(num++, pParent, "军事操作", "inspiration", "军事相关的操作", new UnityAction(tryToOpenWindow3));
			CreateNewActiveGodpower(num++, pParent, "外交操作", "historyLog", "外交相关的操作", new UnityAction(tryToOpenWindow4));
			CreateNewActiveGodpower(num++, pParent, "更多法则", "historyLog", "更多的世界法则", new UnityAction(tryToOpenWindow5));
			#endregion
		}

		public static void CreateNewActiveGodpower(int index, Transform pParent, string powerID, string pSprite, string pDescription, UnityAction pCall = null)
		{
			GodPower godPower = new GodPower();
			godPower.id = powerID;
			godPower.name = powerID;
			godPower.unselectWhenWindow = true;
			switch (powerID)
			{
				case "指定宣战":
					godPower.click_action = (PowerActionWithID)Delegate.Combine(godPower.click_action, new PowerActionWithID(tryToWar));
					break;
				case "指定和平":
					godPower.click_action = (PowerActionWithID)Delegate.Combine(godPower.click_action, new PowerActionWithID(tryToPeace));
					break;
				case "国家操作":
				case "村庄操作":
				case "军事操作":
				case "外交操作":
				case "更多法则":
					break;
				default:
					return;
			}
			AssetManager.powers.add(godPower);
			GameObject gameObject = NewFunction.CreateNewButton(index, pParent, pSprite, godPower, pDescription, pCall, PowerButtonType.Active);
			switch (powerID)
			{
				case "国家操作":
					KingdomPowerWindow.powerButton = gameObject.GetComponent<PowerButton>();
					break;
				case "村庄操作":
					CityPowerWindow.powerButton = gameObject.GetComponent<PowerButton>();
					break;
				case "军事操作":
					ArmyPowerWindow.powerButton = gameObject.GetComponent<PowerButton>();
					break;
				case "外交操作":
					DiplomacyPowerWindow.powerButton = gameObject.GetComponent<PowerButton>();
					break;
				default:
					break;
			}
		}

		public static void CreateNewSpecialGodpower(int index, Transform pParent, string powerID, string pSprite, string pDescription,UnityAction pCall = null)
		{
			GodPower godPower = new GodPower();
			godPower.id = powerID;
			godPower.name = powerID;
			godPower.unselectWhenWindow = true;
			switch (powerID)
			{
				case "全屏烟花":
					godPower.toggle_action = (PowerToggleAction)Delegate.Combine(godPower.toggle_action, new PowerToggleAction(tryToCelebrate));
					break;
				default:
					godPower.toggle_action = (PowerToggleAction)Delegate.Combine(godPower.toggle_action, new PowerToggleAction(toggleOption));
					break;
			}
			AssetManager.powers.add(godPower);
			GameObject gameObject = NewFunction.CreateNewButton(index, pParent, pSprite, godPower, pDescription, pCall, PowerButtonType.Special) ;
			newGameObjects.Add(powerID, gameObject);
		}

		public static void tryToOpenWindow()
		{
			ScrollWindow.showWindow("KingdomControlWindow");
		}
		public static void tryToOpenWindow2()
		{
			ScrollWindow.showWindow("CityControlWindow");
		}
		public static void tryToOpenWindow3()
		{
			ScrollWindow.showWindow("ArmyControlWindow");
		}
		public static void tryToOpenWindow4()
		{
			ScrollWindow.showWindow("DiplomacyControlWindow");
		}
		public static void tryToOpenWindow5()
		{
			ScrollWindow.showWindow("WorldLowControlWindow");
			Main.showWorldLow = true;
		}

		public static bool tryToWar(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (selected_kingdom == null)
			{
				selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要发动一场战争......");
			}
			else
			{
				if (kingdom == selected_kingdom)
				{
					return false;
				}
				MapBox.instance.kingdoms.diplomacyManager.CallMethod("startWar", selected_kingdom, kingdom, false);
				selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToPeace(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (selected_kingdom == null)
			{
				selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要结束一场战争......");
			}
			else
			{
				if (kingdom == selected_kingdom)
				{
					return false;
				}
				MapBox.instance.kingdoms.diplomacyManager.CallMethod("startPeace", selected_kingdom, kingdom, false);
				selected_kingdom = null;
			}

			return true;
		}

		public static void toggleOption(string pPower)
		{
			GodPower godPower = AssetManager.powers.get(pPower);
			WorldTip.instance.showToolbarText(godPower);
			toggles[pPower] = !toggles[pPower];
		}

		public static void tryToCelebrate(string pPower)
		{
			//float timeout = 0.05f;
			foreach(City city in MapBox.instance.citiesList)
			{
				citiesCelebrate.Add(city);
			}
		}

		public static bool tryToCombineArmy(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			City city = pTile.zone.city;
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			if (MoreGodPower.selected_city == null)
			{
				MoreGodPower.selected_city = city;
				MoreGodPower.selected_kingdom = kingdom;
				var data = Reflection.GetField(MoreGodPower.selected_city.GetType(), MoreGodPower.selected_city, "data") as CityData;
				NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "想要在城市 " + data.cityName + " 组建军团");
			}
			else
			{
				if (kingdom != MoreGodPower.selected_kingdom)
					return false;
				var units = Reflection.GetField(MoreGodPower.selected_city.army.GetType(), MoreGodPower.selected_city.army, "units") as ActorContainer;
				foreach (Actor actor in units.getSimpleList())
				{
					MoreGodPower.selected_city.army.removeUnit(actor);
					city.army.addUnit(actor);
				}
				var data = Reflection.GetField(MoreGodPower.selected_city.GetType(), MoreGodPower.selected_city, "data") as CityData;
				NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "组建了 " + data.cityName + " 军团");
				MoreGodPower.selected_city = null;
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}

		public static bool tryToOrderArmy(WorldTile pTile, string pPower)
		{
			if (MoreGodPower.selected_city == null)
			{
				City city = null;
				foreach (WorldTile tile in pTile.zone.tiles)
				{
					if (tile.units.Count > 0)
					{
						foreach (Actor actor in tile.units)
						{
							if (actor.city != null && actor.isGroupLeader)
							{
								city = actor.city;
								break;
							}
						}
					}
				}

				if (city == null)
				{
					return false;
				}
				MoreGodPower.selected_city = city;
				MoreGodPower.selected_kingdom = Reflection.GetField(MoreGodPower.selected_city.GetType(), MoreGodPower.selected_city, "kingdom") as Kingdom;
				var data = Reflection.GetField(MoreGodPower.selected_city.GetType(), MoreGodPower.selected_city, "data") as CityData;
				NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "准备派遣 " + data.cityName + " 军团......");
			}
			else
			{
				var units = Reflection.GetField(MoreGodPower.selected_city.army.GetType(), MoreGodPower.selected_city.army, "units") as ActorContainer;
				if (units.Count > 0)
				{
					foreach (Actor actor in units.getSimpleList())
					{
						actor.cancelAllBeh(null);
						Reflection.SetField<WorldTile>(actor, "beh_tile_target", pTile);
						actor.goTo(pTile);
					}
					var data = Reflection.GetField(MoreGodPower.selected_city.GetType(), MoreGodPower.selected_city, "data") as CityData;
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "的 " + data.cityName + " 军团动身出发。");
				}
				MoreGodPower.selected_kingdom = null;
				MoreGodPower.selected_city = null;
			}
			return true;
		}
	}
}
